/*
 * @(#)ZipButton.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import java.awt.Color;

import com.sun.java.swing.JButton;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.BorderFactory;


/**
 * This class specialize JButton to change the look
 * @see AllActionListener
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipButton extends JButton {
    
    // private members
    private boolean enabled;

    /**
     * Constructor of ZipButton
     * @param action the action perform by the button, to setCommandAction
     * @param iconFileName specify the file name of the icon to display in the button
     */
    public ZipButton(String action, String iconFileName) {
	super(new ImageIcon(iconFileName));
	
	// create the mouse listener for the button
	ListenerButtonMouse ListenerButton = new ListenerButtonMouse(this);
	
	// enable button, dont paint the border, make a specific border, set the action command
	enabled = true;
	setBorderPainted(false);
	setFocusPainted(false);
	setBorder(BorderFactory.createLineBorder(new Color(156, 156, 156)));
	setActionCommand(action);

	// add the mouse listener
	addMouseListener(ListenerButton);
    }


    /**
     * Return the state of the button
     * @return true if enabled
     */
    public boolean isEnabled() {
	return enabled;
    }
    

    /**
     * Enable the button
     * @param flag true to enable it
     */
    public void setButtonEnabled(boolean flag) {
	this.setEnabled(flag);
	enabled = flag;
    }

    /**
     * Internal class to listen the mouse event to change the border if 
     * the mouse enter in the button zone
     * @see ZipButton
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    class ListenerButtonMouse extends MouseAdapter {

	// private member
	private ZipButton zipButton;

	/**
	 * Constructor of the class
	 * @param zipButton an accessor at associate zipButton
	 */
	public ListenerButtonMouse(ZipButton zipButton) {
	    this.zipButton = zipButton;
	}
	

	/**
	 * Method calls when mouse enter in button zone
	 * @param e the mouse event
	 */
	public void mouseEntered(MouseEvent e) {
	    if(zipButton.isEnabled()) {
		zipButton.setBorderPainted(true);
	    }
	}


	/**
	 * Method calls when mouse exited the button zone
	 * @param e the mouse event
	 */
	public void mouseExited(MouseEvent e) {
	    if(zipButton.isEnabled()) {
		zipButton.setBorderPainted(false);
	    }
	}
    }
}
